/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support 
 * ----------------------------------------------------------------------------
 * Copyright (c) 2008, Atmel Corporation
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

//------------------------------------------------------------------------------
/// \unit
///
/// !!!Purpose
/// 
/// This unit provides a very powerful touchscreen driver which handles all the
/// complexity. This includes touchscreen calibration, retrieving measurements,
/// configuring the TSADC, etc.
/// 
/// !!!Usage
/// 
/// -# Call TSD_Initialize() whenever the touchscreen should start the
///    calibration process (as it is done in the function).
/// -# Declare a global TSD_PenPressed function anywhere in your code. This
///    function will get called every time the pen is pressed on the screen.
/// -# Declare a global TSD_PenMoved function, which will get called whenever
///    the pen stays in contact with the screen but changes position.
/// -# Declare a global TSD_PenReleased function, which will be invoked as the
///    pen is lifted from the screen.
//------------------------------------------------------------------------------

#ifndef TSD_H
#define TSD_H

//------------------------------------------------------------------------------
//         Headers
//------------------------------------------------------------------------------

#include "tsd_com.h"

//------------------------------------------------------------------------------
//         Global functions
//------------------------------------------------------------------------------

extern void TSD_Initialize(void *pLcdBuffer);

extern unsigned char TSD_Calibrate(void *pLcdBuffer);

extern void TSD_Reset(void);

#ifdef at91sam3u
extern void TSD_TimerHandler(void);
#endif

#endif //#ifndef TSD_H
