/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support 
 * ----------------------------------------------------------------------------
 * Copyright (c) 2008, Atmel Corporation
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

#ifndef MEDNANDFLASH_H
#define MEDNANDFLASH_H

//------------------------------------------------------------------------------
//         Headers
//------------------------------------------------------------------------------

#include "Media.h"
#include "board.h"
//------------------------------------------------------------------------------
//         Definitions
//------------------------------------------------------------------------------

/// Timer Counter used to flush the nandflash after write operations.
#define AT91C_BASE_NANDFLUSHTIMER   AT91C_BASE_TC1
#define AT91C_ID_NANDFLUSHTIMER     AT91C_ID_TC1

#ifndef AT91C_ID_TC1
#if defined(AT91C_ID_TC012)
    #define AT91C_ID_NANDFLUSHTIMER AT91C_ID_TC012
#elif defined(AT91C_ID_TC)
    #define AT91C_ID_NANDFLUSHTIMER AT91C_ID_TC
#else
    #error Pb define ID_TC
#endif
#endif

//------------------------------------------------------------------------------
//         Forward declarations
//------------------------------------------------------------------------------

struct TranslatedNandFlash;

//------------------------------------------------------------------------------
//         Exported functions
//------------------------------------------------------------------------------

extern void MEDNandFlash_Initialize(
    Media *media,
    struct TranslatedNandFlash *tnf);

#endif //#ifndef MEDNANDFLASH_H

