"""
pachube_test1.py - simple temperature sensor example for www.pachube.com

This example as written runs on a Synapse SN111 End Device Demonstration Board.

This board comes with a thermistor already connected to analog input 0.
"""
from synapse.platforms import *

# This must match your hardware
LED_PIN = GPIO_0
TEMPERATURE_ADC_CHANNEL = 0

# This must match what you setup previously on www.pachube.com
FEED_ID = "48795"
STREAM_ID = "TEMP1"

@setHook(HOOK_1S)
def everySecond():
    value = readAdc(TEMPERATURE_ADC_CHANNEL)
    mcastRpc(1, 2, 'update_stream', FEED_ID, STREAM_ID, value, 'ntcTempF')
    pulsePin(LED_PIN, 300, True)

@setHook(HOOK_STARTUP)
def startup():
    setPinDir(LED_PIN, True)
