'''snapConversions -- Application specific conversion functions
   These functions are used to process raw data reported by remote SNAP devices, before
   sending the data to the cloud.
   
   Calling contract:  conversion_func(data_name, data_value)   # Return float value of processed (I16) data

This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
Contributor: Synapse Wireless Inc., Huntsville, Alabama, 35806, USA
'''

# NOTE:  Add your own conversion functions below.  The example conversions below were used to
#        handle SNAP-based refrigerator controllers, which reported raw ADC readings of thermistors.

import thermistor

def convertAdcToResistance(adcReading):
    # Signal conditioning properties
    rPullup = 10000.0   # Pullup resistor for thermistor
    adcFullscale = 1023
    
    rMeas = rPullup * adcReading / (adcFullscale - adcReading)
    return rMeas

def ntcTempF(name, adcReading):
    """Conversion: Invoked by nodes that have temperature sensors"""
    rMeas = convertAdcToResistance(adcReading)
    
    # Known devices
    devices = {'BeerFridge':3000, 'Subzero':3988}
    
    if name in devices:
        beta = devices[name]
    else:
        beta = 3100

    # Thermistor device properties
    r25 = 10000.0
    temperature = thermistor.fahrenheit(thermistor.ntcTherm(rMeas, beta, r25))

    return temperature

