'''Thermistor measurement and temperature conversion

This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
Contributor: Synapse Wireless Inc., Huntsville, Alabama, 35806, USA
'''

import math

def ntcTherm(rMeasured, beta, r25):
    '''Approximate temperature using Steinhart-Hart equation.
       Given measured resistance, device Beta value, and nominal (25C) resistance,
       return temperature in Kelvin.
    '''
    To = 298.15     # K = 25C
    r_inf = r25 * math.exp(-beta / To)
    return beta / math.log(rMeasured / r_inf)
    
def celsius(tempK):
    return tempK - 273.15

def fahrenheit(tempK):
    return (celsius(tempK) * 9.0/5) + 32

#---------------------------------------------------------------------------------------------------
if __name__ == '__main__':
    # Test with Epcos thermistor P/N:B57891m0104j000
    B = 4450.0      # K
    R25 = 100000.0  # Ohms
    
    Rmeasured = 100000
    
    tempK = ntcTherm(Rmeasured, B, R25)
    
    tempC = celsius(tempK)
    tempF = fahrenheit(tempK)
    
    print str(tempC) + 'C, ' + str(tempF) + 'F'
